"""
AjaxSEC Configuration
- This file is used for default values.
- The INGEST_URL is now provided by the systemd service, not here.
"""

CONFIG = {
    "user": {
        "BEACON_tag": "AjaxSEC-v1.0.0",
        "IP": "Automatic",
    },

    "capture": {
        # This is the default interface. The provisioning script will attempt
        # to change this to 'eth0' which is a more common default for servers.
        "interface": "eth0",
        "Protocol_Filter": "TCP",
    },

    "triggers": {
        "Trigger": "P",
        "PPS_THRESH": 1000,
        "MBPS_THRESH": 20,
        "PAUSE": 60,
        "ConCount": 2000,
        "Attack_occurrences": 500,
        "END_GRACE": 15, # Seconds traffic must be below threshold to be 'ended'
    },

    "colors": {
        "OK_BLUE": 34,
        "OK_GREEN": 92,
        "FAIL": 91,
        "PINK": 35,
        "RESET": 0,
    },
}
